﻿using System;
using System.Collections.Generic;
using System.Linq;
using BMS.Utils;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Via.Commands.EIS;
using BMS.VistaIntegration.Via.Commands.EntityCommands;

namespace BMS.VistaIntegration.Via.Commands.WF
{
    public class ListClinicAppointmentsCommand : BaseListPeriodCommand<ClinicAppointment>
    {
        public ListClinicAppointmentsCommand(ViaVistAQuery query)
            : base(query)
        {
        }

        public string ClinicIen
        {
            get;
            set;
        }

        public override List<ClinicAppointment> Execute(ViaVistASession session)
        {
            if (string.IsNullOrEmpty(this.ClinicIen))
            {
                return null;
            }

            return base.Execute(session);
        }

        protected override string GetTarget()
        {
            return "ListClinicAppointments";
        }

        protected override IEnumerable<object> GetCriteria()
        {
            yield return this.ClinicIen;
            yield return this.StartDate.GetValueOrDefault(MinDate);
            yield return this.EndDate.GetValueOrDefault(this.MaxDate);
            yield return this.MaxCount;
            yield return this.From;
        }
    }
}
